<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class TeacherRequirement
 *
 * @property $id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property TeacherDocument[] $teachersDocuments
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class TeacherRequirement extends Model implements Auditable
{
    protected $table = 'requisitos_docentes';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'nombre' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['nombre'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function teachersDocuments()
    {
        return $this->hasMany('App\Models\TeacherDocument', 'teacher_requirement_id', 'id');
    }
}
