<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class TeacherDocument
 *
 * @property $id
 * @property $teacher_requirement_id
 * @property $teacher_id
 * @property $approved_by
 * @property $documento
 * @property $estado
 * @property $created_at
 * @property $updated_at
 * 
 * @property TeacherRequirement $requirement
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class TeacherDocument extends Model implements Auditable
{
    protected $table = 'documentos_docentes';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'teacher_requirement_id' => 'required|exists:requisitos_docentes,id',
        'teacher_id' => 'required|exists:docentes,id',
        'approved_by' => 'required|exists:administradores,id',
        'documento' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['teacher_requirement_id', 'teacher_id', 'approved_by', 'documento', 'estado'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function requirement()
    {
        return $this->belongsTo('App\Models\TeacherRequirement', 'teacher_requirement_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function teacher()
    {
        return $this->belongsTo('App\Models\Teacher', 'teacher_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function administrator()
    {
        return $this->belongsTo('App\Models\Administrator', 'approved_by', 'id');
    }
}
