<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Tdfilemovement
 *
 * @property $id
 * @property $nro_item
 * @property $nombre
 * @property $ruta_archivo
 * @property $estado
 * @property $tdmovement_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Tdmovement $tdmovement
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tdfilemovement extends Model implements Auditable
{
  protected $table = 'td_movimientos_archivos';

  use \OwenIt\Auditing\Auditable;

    static $rules = [
		'tdmovement_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['nro_item','nombre','ruta_archivo','estado','tdmovement_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function tdmovement()
    {
        return $this->hasOne('App\Models\Tdmovement', 'id', 'tdmovement_id');
    }


}
