<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Tdfile
 *
 * @property $id
 * @property $nro_item
 * @property $nombre
 * @property $ruta_archivo
 * @property $estado
 * @property $tddocument_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Tddocument $tddocument
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tdfile extends Model implements Auditable
{
  protected $table = 'td_archivos';

  use \OwenIt\Auditing\Auditable;

    static $rules = [
		'tddocument_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['nro_item','nombre','ruta_archivo','estado','tddocument_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function tddocument()
    {
        return $this->hasOne('App\Models\Tddocument', 'id', 'tddocument_id');
    }


}
