<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Tdarea
 *
 * @property $id
 * @property $NOMBRE
 * @property $CREACION_FECHA
 * @property $ESTADO
 * @property $created_at
 * @property $updated_at
 *
 * @property Role[] $roles
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tdarea extends Model implements Auditable
{
    protected $table = 'td_areas';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['NOMBRE', 'CREACION_FECHA', 'ESTADO'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function roles()
    {
        return $this->hasMany('App\Models\Role', 'tdarea_id', 'id');
    }
}
