<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class TdMovimiento extends Model implements Auditable
{
    protected $table = 'td_movimientos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'fecha' => 'required',
        'area_origen_id' => 'required',
        'area_destino_id' => 'required',
        'td_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'fecha',
        'area_origen_id',
        'area_destino_id',
        'td_id',
        'nota',
        'pdf_respuesta',
        'nota_respuesta',
        'fecha_respuesta',
        'td_estado_id',
        'is_activo'
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function area_origen()
    {
        return $this->hasOne('App\Models\Area', 'id', 'area_origen_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function area_destino()
    {
        return $this->hasOne('App\Models\Area', 'id', 'area_destino_id');
    }
}
