<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Td extends Model implements Auditable
{
    protected $table = 'tds';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'serie' => 'required',
        'numero' => 'required',
        'info_asunto' => 'required',
        'info_documentos' => 'required',
        'info_folios' => 'required',
        'fecha' => 'required',
        'is_eliminado' => 'required',
        'is_derivado' => 'required',
        'pdf_recibido' => 'required',
        'pdf_respuesta' => 'required',
        'area_id' => 'required',
        'td_tipo_id' => 'required',
        'td_estado_id' => 'required',
        'user_id' => 'required'
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'serie',
        'numero',
        'info_asunto',
        'info_documentos',
        'info_folios',
        'fecha',
        'is_eliminado',
        'is_derivado',
        'pdf_recibido',
        'pdf_respuesta',
        'area_id',
        'td_tipo_id',
        'td_estado_id',
        'user_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function area()
    {
        return $this->hasOne('App\Models\Area', 'id', 'area_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function td_tipo()
    {
        return $this->hasOne('App\Models\TdTipo', 'id', 'td_tipo_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function td_estado()
    {
        return $this->hasOne('App\Models\TdEstado', 'id', 'td_estado_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function user()
    {
        return $this->hasOne('App\Models\User', 'id', 'user_id');
    }

    public function programa()
    {
        return $this->hasOne('App\Models\Program', 'id', 'programa_id');
    }

    public function td_tipo_solicitante()
    {
        return $this->hasOne('App\Models\TdTipoSolicitante', 'id', 'tipo_solicitante_id');
    }

    public function tipo_identificacion()
    {
        return $this->hasOne('App\Models\Identificationtype', 'id', 'tipo_identificacion_id');
    }
}
