<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Module
 *
 * @property $id
 * @property $menu_id
 * @property $nombre
 * @property $route
 * @property $pocision_sm
 * @property $created_at
 * @property $updated_at
 *
 * @property Permission[] $permisos
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Submodule extends Model implements Auditable
{
  protected $table = 'sub_modulos';

  use HasFactory, \OwenIt\Auditing\Auditable;

  static $rules = [
    'module_id' => 'required',
    'nombre' => 'required',
    'route' => 'required',
    'pocision_sm' => 'required',

  ];


  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */

 protected $fillable = ['module_id', 'name', 'route','pocision_sm'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
   */
  public function menu()
  {

  return $this->belongsTo('App\Models\Module', 'modulo_id', 'id');

  }
}
