<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Subjectenrollment extends Model implements Auditable
{
    protected $table = 'matriculas_asignaturas';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'student_id' => 'required',
        'subject_id' => 'required',
        'nota' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['student_id', 'subject_id', 'nota', 'estado'];

    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }

    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }

    public function studentgrade()
    {
        return $this->hasMany('App\Models\Studentgrade', 'subjectenrollment_id', 'id');
    }

    public function practice()
    {
        return $this->hasMany('App\Models\Practice', 'subjectenrollment_id', 'id');
    }
}
