<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Subjectclass
 *
 * @property $id
 * @property $schedule_id
 * @property $nombre
 * @property $dia
 * @property $fecha
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade[] $grades
 * @property Schedule $schedule
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Subjectclass extends Model implements Auditable
{
    protected $table = 'clases_asignaturas';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'schedule_id' => 'required',
        'nombre' => 'required',
        'dia' => 'required',
        'fecha' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['schedule_id', 'nombre', 'dia', 'fecha', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function grades()
    {
        return $this->hasMany('App\Models\Grade', 'subjectclass_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function schedule()
    {
        return $this->hasOne('App\Models\Schedule', 'id', 'schedule_id');
    }
}
