<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Studentvalidation
 *
 * @property $id
 * @property $courseequivalence_id
 * @property $student_id
 * @property $fecha
 * @property $documento
 * @property $created_at
 * @property $updated_at
 *
 * @property Courseequivalence $courseequivalence
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Studentvalidation extends Model implements Auditable
{
    protected $table = 'convalidaciones_estudiantes';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'courseequivalence_id' => 'required',
		'student_id' => 'required',
		'fecha' => 'required',
		'documento' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['courseequivalence_id','student_id','fecha','documento'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function courseequivalence()
    {
        return $this->hasOne('App\Models\Courseequivalence', 'id', 'courseequivalence_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }


}
