<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Studentgrade
 *
 * @property $id
 * @property $subjectenrollment_id
 * @property $grade_id
 * @property $asistencia
 * @property $nota
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade $grade
 * @property Subjectenrollment $subjectenrollment
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Studentgrade extends Model implements Auditable
{
    protected $table = 'notas_estudiantes';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'subjectenrollment_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subjectenrollment_id', 'grade_id', 'asistencia', 'nota', 'retroalimentacion'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function grade()
    {
        return $this->hasOne('App\Models\Grade', 'id', 'grade_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectenrollment()
    {
        return $this->hasOne('App\Models\Subjectenrollment', 'id', 'subjectenrollment_id');
    }
}
