<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Studentdocument extends Model implements Auditable
{
  protected $table = 'documentos_estudiantes';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'fecha_solicitud' => 'required',
    'fecha_inicio' => 'required',
    'nombre' => 'required',
    'tiempo' => 'required',
    'ruta' => 'required',
    'descripcion' => 'required',
    'estado' => 'required',
    'student_id' => 'required',
    'payment_id' => 'required',
  ];

  protected $perPage = 20;

  protected $fillable = [
    'fecha_solicitud',
    'fecha_inicio',
    'nombre',
    'tiempo',
    'ruta',
    'descripcion',
    'estado',
    'student_id',
    'payment_id'
  ];

  public function student()
  {
    return $this->hasOne('App\Models\Student', 'id', 'student_id');
  }
}
