<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Semesterperiod extends Model implements Auditable
{
    protected $table = 'periodos_semestres';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'semester_id' => 'required',
        'period_id' => 'required',
        'moodle_parent_category_id' => 'required',
        'moodle_category_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['semester_id', 'period_id', 'moodle_parent_category_id', 'moodle_category_id'];

    public function period()
    {
        return $this->hasOne('App\Models\Period', 'id', 'period_id');
    }

    public function semester()
    {
        return $this->hasOne('App\Models\Semester', 'id', 'semester_id');
    }
}
