<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Semesterenrollment
 *
 * @property $id
 * @property $semester_id
 * @property $student_id
 * @property $docboucher
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Semester $semester
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Semesterenrollment extends Model implements Auditable
{
    protected $table = 'matriculas_semestres';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'fecha' => 'required',
        'semester_id' => 'required',
        'student_id' => 'required',
        'docboucher' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['fecha', 'semester_id', 'student_id', 'docboucher', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function semester()
    {
        return $this->hasOne('App\Models\Semester', 'id', 'semester_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }
}
