<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Semester extends Model implements Auditable
{
    protected $table = 'semestres';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'anho' => 'required',
        'numero' => 'required',
        'tipo' => 'required',
        'fecinicio' => 'required',
        'fecfin' => 'required',
        'informacion' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [ 
        'anho', 
        'numero', 
        'tipo', 
        'fecinicio', 
        'fecfin', 
        'estado', 
        'informacion', 
        'creditaje',
        'porcentaje_inasistencias',
        'nota_minima',
        'fecha_inicio_matricula', 
        'fecha_fin_matricula',
        'fecha_inicio_notas',
        'fecha_fin_notas',
        'fecha_inicio_actas',
        'fecha_fin_actas',
    ];

    public function semesterenrollments()
    {
        return $this->hasMany('App\Models\Semesterenrollment', 'semester_id', 'id');
    }

    public function semesterperiods()
    {
        return $this->hasMany('App\Models\Semesterperiod', 'semester_id', 'id');
    }

    public function subjects()
    {
        return $this->hasMany('App\Models\Subject', 'semester_id', 'id');
    }
}
