<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Role
 *
 * @property $id
 * @property $nombre
 * @property $descripcion
 * @property $tdarea_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Administrator[] $administradores
 * @property Permission[] $permisos
 * @property Tdarea $tdarea
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Role extends Model implements Auditable
{
    protected $table = 'roles';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
		'nombre' => 'required',
		'descripcion' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['codigo', 'nombre','descripcion','tdarea_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function administradores()
    {
        return $this->hasMany('App\Models\Administrator', 'role_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function permisos()
    {
        return $this->hasMany('App\Models\Permission', 'role_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function tdarea()
    {
        return $this->hasOne('App\Models\Tdarea', 'id', 'tdarea_id');
    }

        /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function roles_areas()
    {
        return $this->hasMany('App\Models\RoleArea', 'role_id', 'id');
    }


}
