<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class RespuestaUsuario extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'respuestas_usuarios';

    protected $fillable = [
        'user_id',
        'pregunta_id',
        'respuesta_id',
        'respuesta_texto',
    ];

    // Relación con usuario
    public function usuario()
    {
        return $this->belongsTo(User::class);
    }

    // Relación con pregunta
    public function pregunta()
    {
        return $this->belongsTo(Pregunta::class);
    }

    // Relación con respuesta
    public function respuesta()
    {
        return $this->belongsTo(RespuestaUsuario::class);
    }
}
