<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;


class Publicacion extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'publicacions';


    static $rules = [
		'titulo' => 'required',
		'contenido' => 'required',
		'carpeta' => 'required',
		'imagen' => 'required',
        'dirigido_a' => 'required',
		'program_id' => 'required',

    ];

    protected $perPage = 20;

 /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['titulo','contenido','carpeta','imagen','dirigido_a','program_id'];


        /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function Program()
    {
        return $this->hasOne('App\Models\Program', 'id', 'program_id');
    }

}
