<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Program
 *
 * @property $id
 * @property $codprograma
 * @property $nombre
 * @property $nivel_formativo
 * @property $created_at
 * @property $updated_at
 *
 * @property Plan[] $plans
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Program extends Model implements Auditable
{
    protected $table = 'programas';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'codprograma' => 'required',
        'nombre' => 'required',
        'nivel_formativo' => 'required',
        'moodle_programa_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['codprograma', 'nombre', 'nivel_formativo', 'moodle_programa_id'];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function plans()
    {
        return $this->hasMany('App\Models\Plan', 'program_id', 'id');
    }

    public function publicaciones()
    {
        return $this->hasMany('App\Models\Publicacion', 'program_id', 'id');
    }
}
