<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Pregunta extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'preguntas';

    protected $fillable = [
        'encuesta_id',
        'contenido',
        'tipo',
    ];

    // Relación con encuesta
    public function encuesta()
    {
        return $this->belongsTo(Encuesta::class);
    }

    // Relación con respuestas
    public function respuestas()
    {
        return $this->hasMany(RespuestaUsuario::class);
    }

    // Relación con respuestas de usuarios
    public function respuestasUsuarios()
    {
        return $this->hasMany(RespuestaUsuario::class);
    }
}
