<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Practice extends Model implements Auditable
{
    protected $table = 'practicas_efsrt';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'agreement_id' => 'required',
		'subjectenrollment_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
        'agreement_id',
        'subjectenrollment_id',
        'fecha_fin',
        'documento',
        'descripcion'
    ];

    public function agreement()
    {
        return $this->hasOne('App\Models\Agreement', 'id', 'agreement_id');
    }

    public function subjectenrollment()
    {
        return $this->hasOne('App\Models\Subjectenrollment', 'id', 'subjectenrollment_id');
    }

}
