<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Planequivalence
 *
 * @property $id
 * @property $plan_id1
 * @property $plan_id2
 * @property $documento
 * @property $created_at
 * @property $updated_at
 *
 * @property Courseequivalence[] $courseequivalences
 * @property Plan $plan
 * @property Plan $plan
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Planequivalence extends Model implements Auditable
{
    protected $table = 'equivalencias_planes';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'plan_id1' => 'required',
        'plan_id2' => 'required',
        'documento' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['plan_id1', 'plan_id2', 'documento'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function courseequivalences()
    {
        return $this->hasMany('App\Models\Courseequivalence', 'planequivalence_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan1()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id2');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan2()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id1');
    }
}
