<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Plan extends Model implements Auditable
{
    protected $table = 'planes';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'nombre' => 'required',
        'tipo' => 'required',
        'modalidad' => 'required',
        'enfoque' => 'required',
        'program_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['nombre', 'tipo', 'modalidad', 'enfoque', 'fecha', 'documento', 'program_id'];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];


    public function admissionplans()
    {
        return $this->hasMany('App\Models\Admissionplan', 'plan_id', 'id');
    }

    public function periods()
    {
        return $this->hasMany('App\Models\Period', 'plan_id', 'id');
    }

    public function modulosformativos()
    {
        return $this->hasMany('App\Models\Trainingmodule', 'plan_id', 'id');
    }

    public function planequivalences2()
    {
        return $this->hasMany('App\Models\Planequivalence', 'plan_id2', 'id');
    }

    public function planequivalences1()
    {
        return $this->hasMany('App\Models\Planequivalence', 'plan_id1', 'id');
    }

    public function program()
    {
        return $this->hasOne('App\Models\Program', 'id', 'program_id');
    }

    public function students()
    {
        return $this->hasMany('App\Models\Student', 'plan_id', 'id');
    }

    public function Publicacion()
    {
        return $this->hasMany('App\Models\Publicacion', 'plan_id', 'id');
    }

    public function Encuesta()
    {
        return $this->hasMany('App\Models\Encuesta', 'plan_id', 'id');
    }
}
