<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Personalappointment extends Model implements Auditable
{
    protected $table = 'citas_presenciales';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'dni' => 'required',
        'nombres' => 'required',
        'apellido_pa' => 'required',
        'apellido_ma' => 'required',
        'email' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
        'dni',
        'nombres',
        'apellido_pa',
        'apellido_ma',
        'email',
        'celular',
        'asunto',
        'datos_cita',
        'fecha',
        'hora_ini',
        'hora_fin',
        'estado'
    ];
}
