<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class ParametroAcademico extends Model implements Auditable
{
    protected $table = 'parametros_academicos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'short_name' => 'required',
        'name' => 'required',
        'value' => 'required',
        'description' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['short_name', 'name', 'value', 'description'];


}
