<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class PagoMatricula
 *
 * @property $id
 * @property $fecha
 * @property $pago_id
 * @property $semester_id
 * @property $created_at
 * @property $updated_at
 *
 * @property PagoMatricula[] $pagos_matriculas
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class PagoMatricula extends Model implements Auditable
{
    protected $table = 'pagos_matriculas';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'fecha' => 'required',
        'pago_id' => 'required',
        'semester_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['fecha', 'pago_id', 'semester_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function pago()
    {
        return $this->hasOne('App\Models\Pago', 'id', 'pago_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function semester()
    {
        return $this->hasOne('App\Models\Semester', 'id', 'semester_id');
    }


}
