<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Pago
 *
 * @property $id
 * @property $student_id
 * @property $administrator_id
 * @property $concepto_id
 * @property $metodo_pago_id
 * @property $banco_id
 * @property $fecha
 * @property $documento
 * @property $nro_operacion
 * @property $monto_inicial
 * @property $descuento
 * @property $monto_final
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Pago[] $pagos
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Pago extends Model implements Auditable
{
    protected $table = 'pagos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'student_id' => 'required',
        'administrator_id' => 'required',
        'concepto_id' => 'required',
        'fecha' => 'required',
        'documento' => 'required',
        'nro_operacion' => 'required',
        'monto_inicial' => 'required',
        'descuento' => 'required',
        'monto_final' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['student_id', 'administrator_id', 'concepto_id', 'metodo_pago_id', 'banco_id', 'fecha', 'documento', 'nro_operacion', 'monto_inicial', 'descuento', 'monto_final', 'estado', 'documento_descuento'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function administrator()
    {
        return $this->hasOne('App\Models\Administrator', 'id', 'administrator_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function concepto()
    {
        return $this->hasOne('App\Models\Concepto', 'id', 'concepto_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function metodo_pago()
    {
        return $this->hasOne('App\Models\MetodoPago', 'id', 'metodo_pago_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function banco()
    {
        return $this->hasOne('App\Models\Banco', 'id', 'banco_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function pagos_matriculas()
    {
        return $this->hasMany('App\Models\PagoMatricula', 'pago_id', 'id');
    }
}
