<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class OpcionRespuesta extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'opciones_respuesta';

    protected $fillable = [
        'pregunta_id',
        'contenido',
    ];

    // Relación con pregunta
    public function pregunta()
    {
        return $this->belongsTo(Pregunta::class);
    }
}
