<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Module
 *
 * @property $id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property Permission[] $permisos
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Module extends Model implements Auditable
{
  protected $table = 'modulos';

  use HasFactory, \OwenIt\Auditing\Auditable;

  static $rules = [
    'short_name' => 'required',
    'nombre' => 'required',
    'pocision' => 'required',

  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['short_name','nombre','pocision'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function permisos()
  {
    return $this->hasMany('App\Models\Permission', 'module_id', 'id');
  }

  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function submodules()
  {
    return $this->hasMany('App\Models\Submodule', 'module_id', 'id');
  }
}
