<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Medicalappointment extends Model implements Auditable
{
  protected $table = 'citas_medicas';

  use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
		'user_id' => 'required',
		'appointment_type_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
      'user_id',
      'appointment_type_id',
      'asunto',
      'descripcion',
      'fecha',
      'hora_ini',
      'hora_fin',
      'motivo_cancelacion',
      'diagnostico',
      'tratamiento',
      'observacion',
      'estado',
    ];

    public function Typeappointments()
    {
        return $this->hasMany('App\Models\Typeappointment', 'appointment_type_id', 'id');
    }

}
