<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Logapplicant
 *
 * @property $id
 * @property $administrator_id
 * @property $applicant_id
 * @property $accion
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Logapplicant extends Model implements Auditable
{
  protected $table = 'log_postulantes';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'administrator_id' => 'required',
    'applicant_id' => 'required',
    'accion' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['administrator_id', 'applicant_id', 'accion'];
}
