<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Logadmission
 *
 * @property $id
 * @property $administrator_id
 * @property $admission_id
 * @property $accion
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Logadmission extends Model implements Auditable
{
  protected $table = 'log_admisiones';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'administrator_id' => 'required',
    'admission_id' => 'required',
    'accion' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['administrator_id', 'admission_id', 'accion'];
}
