<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Jpjobtag
 *
 * @property $id
 * @property $jpjob_id
 * @property $jptag_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjob $jpjob
 * @property Jptag $jptag
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jpjobtag extends Model implements Auditable
{
    protected $table = 'bt_etiquetas_trabajos';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'jpjob_id' => 'required',
		'jptag_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['jpjob_id','jptag_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function jpjob()
    {
        return $this->hasOne('App\Models\Jpjob', 'id', 'jpjob_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function jptag()
    {
        return $this->hasOne('App\Models\Jptag', 'id', 'jptag_id');
    }


}
