<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Jpjobapplication
 *
 * @property $id
 * @property $fecaplicacion
 * @property $estado
 * @property $documento
 * @property $isvisto
 * @property $feedback
 * @property $fecfeedback
 * @property $jpjob_id
 * @property $student_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjob $jpjob
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jpjobapplication extends Model implements Auditable
{
    protected $table = 'bt_solicitudes_empleos';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'fecaplicacion' => 'required',
		'estado' => 'required',
		'documento' => 'required',
		'isvisto' => 'required',
		'feedback' => 'required',
		'fecfeedback' => 'required',
		'jpjob_id' => 'required',
		'student_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['fecaplicacion','estado','documento','isvisto','feedback','fecfeedback','jpjob_id','student_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function jpjob()
    {
        return $this->hasOne('App\Models\Jpjob', 'id', 'jpjob_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }


}
