<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Jpcompany
 *
 * @property $id
 * @property $nombre
 * @property $ruc
 * @property $direccion
 * @property $nrocontacto
 * @property $ishabilitado
 * @property $user
 * @property $password
 * @property $logo
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjob[] $jpjobs
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jpcompany extends Model implements Auditable
{
  protected $table = 'bt_empresas';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'nombre' => 'required',
    'ruc' => 'required',
    'direccion' => 'required',
    'nrocontacto' => 'required',
    'estado' => 'required',
    'user' => 'required',
    'logo' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'ruc', 'direccion', 'nrocontacto', 'estado', 'user', 'logo'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function jpjobs()
  {
    return $this->hasMany('App\Models\Jpjob', 'jpcompany_id', 'id');
  }
}
