<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Jpcategory
 *
 * @property $id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjob[] $jpjobs
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jpcategory extends Model implements Auditable
{
  protected $table = 'bt_categorias';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'nombre' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function jpjobs()
  {
    return $this->hasMany('App\Models\Jpjob', 'jpcategory_id', 'id');
  }
}
