<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class ItemsTitulacion
 *
 * @property $id
 * @property $concepto
 * @property $descripcion
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property DocumentoTitulacion[] $documentosTitulacion
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class ItemsTitulacion extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'items_titulacion';

    static $rules = [
        'concepto'   => 'required',
        'estado'     => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
        'concepto',
        'descripcion',
        'estado',
        'created_at',
        'updated_at',
    ];

    /*
    protected $hidden = [
        'created_at',
        'updated_at',
    ];
    */

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function documentosTitulacion()
    {
        return $this->hasMany(DocumentoTitulacion::class, 'item_titulacion_id', 'id');
    }
}
