<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Institution extends Model implements Auditable
{
  protected $table = 'instituciones';

  use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
		'name' => 'required',
		'direccion' => 'required',
		'contact_number' => 'required',
    'email' => 'required|email',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
      'name',
      'direccion',
      'contact_number',
      'email',
    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function schedules()
    {
        return $this->hasMany('App\Models\ExternalValidation', 'institucion_id', 'id');
    }

}
