<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Gradetype
 *
 * @property $id
 * @property $nombre
 * @property $porcentaje
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade[] $grades
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Gradetype extends Model implements Auditable
{
  protected $table = 'tipos_notas';

  use \OwenIt\Auditing\Auditable;

  static $rules = [
    'nombre' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'porcentaje', 'tipo_nota', 'fecha_limite'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function grades()
  {
    return $this->hasMany('App\Models\Grade', 'gradetype_id', 'id');
  }
}
