<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class ForumResponse
 *
 * @property $id
 * @property $forum_id
 * @property $student_id
 * @property $comentario
 * @property $created_at
 * @property $updated_at
 *
 * @property Forum $forum
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Forumanswer extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;
    protected $table = 'respuestas_foros';

    static $rules = [
        'forum_id' => 'required',
        'student_id' => 'required',
        'comentario' => 'nullable',
    ];

    protected $fillable = ['forum_id', 'student_id', 'comentario'];


    public function forum()
    {
        return $this->hasOne('App\Models\Forum', 'id', 'forum_id');
    }


    public function student()
    {
        return $this->hasMany('App\Models\Student', 'student_id', 'id');
    }
}
