<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Forum
 *
 * @property $id
 * @property $subject_id
 * @property $titulo
 * @property $descripcion
 * @property $fecinicio
 * @property $fecfin
 * @property $ruta
 * @property $archivo
 * @property $created_at
 * @property $updated_at
 *
 * @property Subject $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Forum extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;
    protected $table = 'foros';

    static $rules = [
        'subject_id' => 'required',
        'titulo' => 'required',
        'descripcion' => 'nullable',
        'fecinicio' => 'required',
        'fecfin' => 'required',
        'ruta' => 'nullable',
        'archivo' => 'nullable|string|max:250',
    ];

    protected $fillable = ['subject_id', 'titulo', 'descripcion', 'fecinicio', 'fecfin', 'ruta', 'archivo'];


    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }

    public function forumanswer()
    {
        return $this->hasMany('App\Models\Forumanswer', 'forumanswer_id', 'id');
    }
}
