<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Folders
 *
 * @property $id
 * @property $subject_id
 * @property $nombre
 * @property $descripcion
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Subject[] $subjects
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Folder extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;
    protected $table = 'carpetas';

    static $rules = [
        'subject_id' => 'required',
        'nombre' => 'required',
		'estado' => 'required'
    ];

    protected $perPage = 20;

    protected $fillable = ['subject_id','nombre','descripcion','estado'];

    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }

    public function subfolder()
    {
        return $this->hasMany('App\Models\Subfolder', 'folder_id', 'id');
    }
}
