<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Externaltransfer
 *
 * @property $id
 * @property $institucion_origen
 * @property $programa_origen
 * @property $plan_id2
 * @property $transfer_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Plan $plan
 * @property Transfer $transfer
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Externaltransfer extends Model implements Auditable
{
    protected $table = 'traslados_internos';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'institucion_origen' => 'required',
		'programa_origen' => 'required',
		'plan_id2' => 'required',
		'transfer_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['institucion_origen','programa_origen','plan_id2','transfer_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan2()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id2');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function transfer()
    {
        return $this->hasOne('App\Models\Transfer', 'id', 'transfer_id');
    }


}
