<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Exoneration extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    /**
     * Define el nombre de la tabla de la base de datos.
     *
     * @var string
     */
    protected $table = 'exoneraciones';

    /**
     * Reglas de validación para los atributos del modelo.
     *
     * @var array
     */
    static $rules = [
        'nombre' => 'required|string|max:150',
        'descripcion' => 'nullable|string',
        // Se valida que el documento sea un archivo PDF y no supere los 2MB
        'documento_resolucion' => 'nullable|file|mimes:pdf|max:2048',
        // Se asegura que el descuento sea un número entre 0 y 100
        'porcentaje_descuento' => 'required|numeric|between:0,100',
    ];

    /**
     * Define el número de registros por página para la paginación.
     *
     * @var int
     */
    protected $perPage = 20;

    /**
     * Los atributos que se pueden asignar masivamente.
     *
     * @var array
     */
    protected $fillable = [
        'nombre',
        'descripcion',
        'documento_resolucion',
        'porcentaje_descuento',
    ];

    public function payments()
    {
        // Se asume que el modelo para la tabla 'pagos' se llama 'Pago'.
        return $this->hasMany('App\Models\Pago', 'exoneration_id', 'id');
    }

}