<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Encuesta extends Model implements Auditable
{

    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'encuestas';

    protected $perPage = 20;


    protected $fillable = [
		'plan_id' => 'required',
        'titulo',
        'descripcion',
        'fecha_inicio',
        'fecha_fin',
        'estado',
        'dirigido_a',
        'user_id' => 'required',
    ];

    public function Plan()
    {
        return $this->belongsTo('App\Models\Plan', 'id', 'plan_id');
    }

    // Relación con preguntas
    public function preguntas()
    {
        return $this->hasMany(Pregunta::class);
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'id', 'user_id');
    }
}
