<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class EfsrtEstudiante extends Model implements Auditable
{
    protected $table = 'efsrt_estudiantes';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'efsrt_id' => 'required',
        'agreement_id' => 'required',
        'horas' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;


    protected $fillable = [
        'efsrt_id',
        'agreement_id',
        'horas',
        'estado',
    ];

    // Relations
    public function efsrt()
    {
        return $this->hasOne('App\Models\Efsrt', 'id', 'efsrt_id');
    }

    public function convenio()
    {
        return $this->hasOne('App\Models\Agreement', 'id', 'agreement_id');
    }
}
