<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Efsrt extends Model implements Auditable
{
    protected $table = 'efsrts';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
        'student_id' => 'required',
        'module_training_id' => 'required',
        'total_horas' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;


    protected $fillable = [
        'student_id',
        'module_training_id',
        'total_horas',
        'estado',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    // Relations
    public function modulo_formativo()
    {
        return $this->hasOne('App\Models\Trainingmodule', 'id', 'module_training_id');
    }

    public function estudiante()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }

    public function efsrt_estudiante()
    {
        return $this->hasOne('App\Models\EfsrtEstudiante', 'efsrt_id', 'id');
    }
}
