<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class DocumentoTitulacion
 *
 * @property $id
 * @property $student_id
 * @property $item_titulacion_id
 * @property $archivo
 * @property $estado
 * @property $permiso_observacion
 * @property $created_at
 * @property $updated_at
 *
 * @property Estudiante $estudiante
 * @property ItemsTitulacion $itemTitulacion
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class DocumentoTitulacion extends Model implements Auditable
{
    use HasFactory, \OwenIt\Auditing\Auditable;

    protected $table = 'documento_titulacion';

    static $rules = [
        'student_id'         => 'required',
        'item_titulacion_id' => 'required',
        'archivo'            => 'required',
        'estado'             => 'required',
        'es_visible'            => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
        'student_id',
        'item_titulacion_id',
        'archivo',
        'estado',
        'permiso_observacion',
        'es_visible',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function estudiante()
    {
        return $this->hasOne(Student::class, 'id', 'student_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function itemTitulacion()
    {
        return $this->hasOne(ItemsTitulacion::class, 'id', 'item_titulacion_id');
    }




    
}





