<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Classroom extends Model implements Auditable
{
  protected $table = 'aulas';

  use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
		'tipo' => 'required',
		'numero' => 'required',
		'piso' => 'required',
		'capacidad' => 'required',
    'campus_id' => 'required|exists:sedes,id',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['tipo','numero','piso','capacidad','ubicacion','observacion','campus_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function schedules()
    {
        return $this->hasMany('App\Models\Schedule', 'classroom_id', 'id');
    }

    public function campus()
    {
        return $this->hasOne('App\Models\Campus', 'id', 'campus_id');
    }


}
